-- --------------------------------------------------------
-- Host:                         109.106.254.1
-- Server version:               10.11.7-MariaDB-cll-lve - MariaDB Server
-- Server OS:                    Linux
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table u353443769_beis.dn_auto_atrumkarba
DROP TABLE IF EXISTS `dn_auto_atrumkarba`;
CREATE TABLE IF NOT EXISTS `dn_auto_atrumkarba` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ātrumkārbas id',
  `tipi` varchar(15) NOT NULL COMMENT 'Ātrumkarbas veids',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Ātrumkārbu veidi';

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_bildes
DROP TABLE IF EXISTS `dn_auto_bildes`;
CREATE TABLE IF NOT EXISTS `dn_auto_bildes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bilde` varchar(50) NOT NULL DEFAULT '',
  `masinas_id` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Sludinājumas pievienotās bildes';

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_dzinejs
DROP TABLE IF EXISTS `dn_auto_dzinejs`;
CREATE TABLE IF NOT EXISTS `dn_auto_dzinejs` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Dzinēju veida id',
  `tipi` varchar(20) NOT NULL COMMENT 'Dzinēju veids',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Dzinēju veidi';

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_krasa
DROP TABLE IF EXISTS `dn_auto_krasa`;
CREATE TABLE IF NOT EXISTS `dn_auto_krasa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `krasa` varchar(20) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Mašīnu krāsa';

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_masinas_info
DROP TABLE IF EXISTS `dn_auto_masinas_info`;
CREATE TABLE IF NOT EXISTS `dn_auto_masinas_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Mašīnas id',
  `modelis_id` int(11) NOT NULL COMMENT 'Mašīnas modelis',
  `user id` int(11) NOT NULL COMMENT 'Lietotāja id, lai katrs nevarētu random mašīnas ņemt ārā',
  `izlaiduma_gads` year(4) NOT NULL COMMENT 'Mašīnas izlaiduma gads',
  `tilpums` decimal(5,2) NOT NULL COMMENT 'Mašīnas dzinēja tilpums',
  `dzineja_tips_id` int(11) NOT NULL COMMENT 'Mašīnas dzinēja veids no "rer_autoparks_dzinējs" tabulas',
  `krasa_id` int(11) NOT NULL COMMENT 'Mašīnas krāsa',
  `nobraukums` int(7) NOT NULL DEFAULT 0 COMMENT 'Mašīnas nobraukums',
  `virsbuves_tips_id` int(11) NOT NULL COMMENT 'Mašīnas virsbūves tips no "rer_autoparks_virzsbuves_tips" tabulas',
  `tehn_apskate` date NOT NULL COMMENT 'Līdz kuram datumam ir tehniskā apskate',
  `vin_nr` varchar(17) NOT NULL COMMENT 'VIN numurs jeb šahijas numurs',
  `valsts_nr_zime` varchar(8) NOT NULL COMMENT 'Valsts izsniegtā numurzīme',
  `atrumkarba_tips_id` int(11) NOT NULL COMMENT 'Mašīnas ātrumkārbas tips no "rer_autoparks_atrumkarba" tabulas',
  `atrumi` int(1) NOT NULL COMMENT 'Cik ātrumi ātrumkārbai //automātam nav obligāti',
  `Cena` int(11) NOT NULL COMMENT 'Mašīnas cena',
  `apraksts` text NOT NULL COMMENT 'Mašīnas apraksts',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `vin_nr` (`vin_nr`) USING BTREE,
  UNIQUE KEY `valsts_nr_zime` (`valsts_nr_zime`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_modelis` (`modelis_id`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_dzinejs` (`dzineja_tips_id`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_krasa` (`krasa_id`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_virsbuves_tips` (`virsbuves_tips_id`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_atrumkarba` (`atrumkarba_tips_id`) USING BTREE,
  KEY `FK_rer_autoparks_masinas_info_rer_autoparks_users` (`user id`) USING BTREE,
  CONSTRAINT `dn_auto_masinas_info_ibfk_1` FOREIGN KEY (`atrumkarba_tips_id`) REFERENCES `rer_autoparks_atrumkarba` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `dn_auto_masinas_info_ibfk_2` FOREIGN KEY (`dzineja_tips_id`) REFERENCES `rer_autoparks_dzinejs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `dn_auto_masinas_info_ibfk_3` FOREIGN KEY (`krasa_id`) REFERENCES `rer_autoparks_krasa` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `dn_auto_masinas_info_ibfk_4` FOREIGN KEY (`modelis_id`) REFERENCES `rer_autoparks_modelis` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `dn_auto_masinas_info_ibfk_5` FOREIGN KEY (`user id`) REFERENCES `rer_autoparks_users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `dn_auto_masinas_info_ibfk_6` FOREIGN KEY (`virsbuves_tips_id`) REFERENCES `rer_autoparks_virsbuves_tips` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_modelis
DROP TABLE IF EXISTS `dn_auto_modelis`;
CREATE TABLE IF NOT EXISTS `dn_auto_modelis` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Modeļa id',
  `modelis` varchar(20) NOT NULL COMMENT 'Modeļa nosaukums',
  `marka_id` int(11) NOT NULL COMMENT 'Modeļa un markas sasaistīšanai',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_rer_autoparks_modelis_rer_autoparks_marka` (`marka_id`) USING BTREE,
  CONSTRAINT `dn_auto_modelis_ibfk_1` FOREIGN KEY (`marka_id`) REFERENCES `rer_autoparks_marka` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1985 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Automašīnu modeļi, kuri tiks sasaistīti ar marku';

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_users
DROP TABLE IF EXISTS `dn_auto_users`;
CREATE TABLE IF NOT EXISTS `dn_auto_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Lietotāja id',
  `email` varchar(20) NOT NULL COMMENT 'Lietotāja E-pasts',
  `parole` varchar(20) NOT NULL COMMENT 'Lietotāja parole',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_email` (`email`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.

-- Dumping structure for table u353443769_beis.dn_auto_virsbuves_tips
DROP TABLE IF EXISTS `dn_auto_virsbuves_tips`;
CREATE TABLE IF NOT EXISTS `dn_auto_virsbuves_tips` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Virsbūves tipa id',
  `tipi` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT 'Virsbūves tips',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Automašīnu virsbūves tipi priekš autoparka';

-- Data exporting was unselected.

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
